/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.GlowstoneRuinedPortalPiece;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class GlowstoneRuinedPortalStructure
extends class_3195 {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private final List<Setup> setups;
    public static final MapCodec<GlowstoneRuinedPortalStructure> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)GlowstoneRuinedPortalStructure.method_42697((RecordCodecBuilder.Instance)codec), (App)class_5699.method_36973((Codec)Setup.CODEC.codec().listOf()).fieldOf("setups").forGetter(structure -> structure.setups)).apply((Applicative)codec, GlowstoneRuinedPortalStructure::new));

    public GlowstoneRuinedPortalStructure(class_3195.class_7302 settings, List<Setup> setups) {
        super(settings);
        this.setups = setups;
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        GlowstoneRuinedPortalPiece.Properties pieceProperties = new GlowstoneRuinedPortalPiece.Properties();
        class_2919 worldGenRandom = context.comp_566();
        class_1923 chunkPos = context.comp_568();
        class_2794 chunkGenerator = context.comp_562();
        class_5539 levelHeightAccessor = context.comp_569();
        class_7138 randomState = context.comp_564();
        class_2338 blockPosChunk = context.comp_568().method_8323();
        Setup portalSetup = null;
        if (this.setups.size() > 1) {
            float f = 0.0f;
            for (Setup setup : this.setups) {
                f += setup.weight();
            }
            float f1 = worldGenRandom.method_43057();
            for (Setup setup2 : this.setups) {
                if (!((f1 -= setup2.weight() / f) < 0.0f)) continue;
                portalSetup = setup2;
                break;
            }
        } else {
            portalSetup = this.setups.getFirst();
        }
        if (portalSetup == null) {
            throw new IllegalStateException();
        }
        Setup setup3 = portalSetup;
        pieceProperties.airPocket = GlowstoneRuinedPortalStructure.sample(worldGenRandom, setup3.airPocketProbability());
        pieceProperties.mossiness = setup3.mossiness();
        pieceProperties.overgrown = setup3.overgrown();
        pieceProperties.vines = setup3.vines();
        pieceProperties.replaceWithHolystone = setup3.replaceWithHolystone();
        class_2960 location = worldGenRandom.method_43057() < 0.05f ? class_2960.method_60655((String)"aether", (String)STRUCTURE_LOCATION_GIANT_PORTALS[worldGenRandom.method_43048(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : class_2960.method_60655((String)"aether", (String)STRUCTURE_LOCATION_PORTALS[worldGenRandom.method_43048(STRUCTURE_LOCATION_PORTALS.length)]);
        class_3499 class_34992 = context.comp_565().method_15091(location);
        class_2470 rotation = (class_2470)class_156.method_27173((Object[])class_2470.values(), (class_5819)worldGenRandom);
        class_2415 mirror = worldGenRandom.method_43057() < 0.5f ? class_2415.field_11302 : class_2415.field_11301;
        class_2338 blockPos = new class_2338(class_34992.method_15160().method_10263() / 2, 0, class_34992.method_15160().method_10260() / 2);
        class_3341 boundingbox = class_34992.method_27267(blockPosChunk, rotation, blockPos, mirror);
        class_2338 centerPos = boundingbox.method_22874();
        int i = chunkGenerator.method_16397(centerPos.method_10263(), centerPos.method_10260(), GlowstoneRuinedPortalPiece.getHeightMapType(setup3.placement()), levelHeightAccessor, randomState) - 1;
        int j = GlowstoneRuinedPortalStructure.findSuitableY((class_5819)worldGenRandom, chunkGenerator, setup3.placement(), i, boundingbox.method_14660(), boundingbox, levelHeightAccessor, randomState);
        class_2338 spawnPos = new class_2338(blockPosChunk.method_10263(), j, blockPosChunk.method_10260());
        if (GlowstoneRuinedPortalStructure.validCorners(chunkGenerator, levelHeightAccessor, chunkPos, randomState, spawnPos.method_10264())) {
            return Optional.of(new class_3195.class_7150(spawnPos, builder -> builder.method_35462((class_3443)new GlowstoneRuinedPortalPiece(context.comp_565(), spawnPos, setup3.placement(), pieceProperties, location, rotation, mirror, blockPos))));
        }
        return Optional.empty();
    }

    private static boolean sample(class_2919 random, float threshold) {
        if (threshold == 0.0f) {
            return false;
        }
        if (threshold == 1.0f) {
            return true;
        }
        return random.method_43057() < threshold;
    }

    private static int findSuitableY(class_5819 random, class_2794 chunkGenerator, GlowstoneRuinedPortalPiece.VerticalPlacement verticalPlacement, int height, int blockCountY, class_3341 box, class_5539 heightAccessor, class_7138 randomState) {
        int l;
        int j = heightAccessor.method_31607() + 15;
        int i = verticalPlacement == GlowstoneRuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? height - blockCountY + class_3532.method_32751((class_5819)random, (int)2, (int)8) : height;
        ImmutableList positions = ImmutableList.of((Object)new class_2338(box.method_35415(), 0, box.method_35417()), (Object)new class_2338(box.method_35418(), 0, box.method_35417()), (Object)new class_2338(box.method_35415(), 0, box.method_35420()), (Object)new class_2338(box.method_35418(), 0, box.method_35420()));
        List<class_4966> noiseColumns = positions.stream().map(pos -> chunkGenerator.method_26261(pos.method_10263(), pos.method_10260(), heightAccessor, randomState)).toList();
        class_2902.class_2903 heightmap$types = verticalPlacement == GlowstoneRuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? class_2902.class_2903.field_13200 : class_2902.class_2903.field_13202;
        for (l = i; l > j; --l) {
            int i1 = 0;
            for (class_4966 noiseColumn : noiseColumns) {
                class_2680 blockState = noiseColumn.method_32892(l);
                if (!heightmap$types.method_16402().test(blockState) || ++i1 != 3) continue;
                return l;
            }
        }
        return l;
    }

    private static boolean validCorners(class_2794 generator, class_5539 heightAccessor, class_1923 chunkPos, class_7138 random, int spawnY) {
        class_4966[] columns;
        int minX = chunkPos.method_8326() - 1;
        int minZ = chunkPos.method_8328() - 1;
        int maxX = chunkPos.method_8327() + 1;
        int maxZ = chunkPos.method_8329() + 1;
        for (class_4966 column : columns = new class_4966[]{generator.method_26261(minX, minZ, heightAccessor, random), generator.method_26261(minX, maxZ, heightAccessor, random), generator.method_26261(maxX, minZ, heightAccessor, random), generator.method_26261(maxX, maxZ, heightAccessor, random)}) {
            if (column.method_32892(spawnY).method_26215() || column.method_32892(spawnY).method_26164(AetherTags.Blocks.NON_RUINED_PORTAL_SPAWNABLE)) continue;
            return true;
        }
        return false;
    }

    public class_7151<?> method_41618() {
        return AetherStructureTypes.RUINED_PORTAL.get();
    }

    public record Setup(GlowstoneRuinedPortalPiece.VerticalPlacement placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean replaceWithHolystone, float weight) {
        public static final MapCodec<Setup> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)GlowstoneRuinedPortalPiece.VerticalPlacement.CODEC.fieldOf("placement").forGetter(Setup::placement), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(Setup::airPocketProbability), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(Setup::mossiness), (App)Codec.BOOL.fieldOf("overgrown").forGetter(Setup::overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(Setup::vines), (App)Codec.BOOL.fieldOf("replace_with_holystone").forGetter(Setup::replaceWithHolystone), (App)class_5699.field_34387.fieldOf("weight").forGetter(Setup::weight)).apply((Applicative)codec, Setup::new));
    }
}

